// create a new spawnmenu class
local CPreview	= OOP_Derive( CTimer, CCommand, CUtility );

// constructor
function CPreview:__ctor( )
	// hook preview commands.
	self:HookCommand( "VMF_AcceptPreview" );
	self:HookCommand( "VMF_HaltPreview" );
	
	// timer frequency.
	self:SetFrequency( 0.15 );
	
end

// accept the preview.
function CPreview:OnVMF_AcceptPreview( pl, args )
	// accept the preview.
	pl.PreviewResponse	= true;	

end

// halt the preview.
function CPreview:OnVMF_HaltPreview( pl, args )
	// wipe the list
	pl.PreviewSendBuffer 	= {};
	pl.PreviewSending	= false;

end


// clear preview
function CPreview:Clear( pl )
	// wipe the list
	pl.PreviewSendBuffer 	= {};
	pl.PreviewSending	= false;

	// cleanup the mess ont he client.
	umsg.Start( "ClearPreview", pl );
	umsg.End();
	
end


// Dispatch
function CPreview:DispatchPreview( pl, vmf, filename, copy )
	// setup the player table.
	pl.PreviewSendBuffer 	= {};
	pl.PreviewSending 	= true;
	pl.PreviewResponse	= false;
	
	// parse the preview entities to send.
	local i;
	for i = 0, vmf:EntityCount() - 1 do
		// fetch entity.
		local ent = vmf:Entity( i );
		
		// have a model?!?
		local _, model = ent:FindKey( "model" );
		
		// have a model and not an env_sprite?
		if( model && ent:Class() != "env_sprite" ) then
			// read the required data.
			local _, origin = ent:FindKey( "origin" );
			local _, angles = ent:FindKey( "angles" );
			local _, color = ent:FindKey( "rendercolor" );
			local _, rendermode = ent:FindKey( "rendermode" );
			
			// create the preview entity to send.
			local preview = {
				model = model,
				origin = self:StringToVector( origin or "0 0 0" ),
				angles = self:StringToVector( angles or "0 0 0" ),
				color = self:StringToVector( color or "255 255 255" ),
				rendermode = tonumber( rendermode or "4" ),

			};
			
			// add
			table.insert( pl.PreviewSendBuffer, preview );
		
		end
	
	end
	
	// clear any existing previews.
	umsg.Start( "ClearPreview", pl );
	umsg.End();
	
	// initialize the preview on the client.
	umsg.Start( "InitPreview", pl );
		umsg.Short( table.getn( pl.PreviewSendBuffer ) );
		umsg.String( filename );
		umsg.Bool( copy or false );
	umsg.End();
	
end

// timer event.
function CPreview:OnTimer( )
	// send previews for each player.
	local plyrs, pl = player.GetAll();
	for _, pl in pairs( plyrs ) do
		// are we sending a preview?
		if( pl.PreviewResponse && pl.PreviewSending && table.getn( pl.PreviewSendBuffer ) > 0 ) then
			// the number of entities.
			local count = table.getn( pl.PreviewSendBuffer );
		
			// determine how much data to send.
			local sendCount = 3;
			if( sendCount > count ) then
				sendCount = count;
				
			end
			
			// send the chunk.
			local i;
			for i = 1, sendCount do
				// pull the first entity off the list.
				local ent = pl.PreviewSendBuffer[1];
				table.remove( pl.PreviewSendBuffer, 1 );
				
				// send entity.
				umsg.Start( "AddPreviewEntity", pl );
					umsg.String( ent.model );
					umsg.Vector( ent.origin );
					umsg.Vector( ent.angles );
					umsg.Vector( ent.color );
					umsg.Short( ent.rendermode );
				umsg.End();
				
			end
			
		// sent?
		elseif( pl.PreviewResponse && pl.PreviewSending ) then
			// display the preview to the client - Deprecated
			//umsg.Start( "VMFSuite-ShowPreview", pl );
			//umsg.End();
			
			// stop sending the preview.
			pl.PreviewSending = false;
			
		end
		
	end
	
end

// create
VMFSuite.PreviewSystem = CPreview:create();
